/////////////////////////////////////////////////////////////////////////////
// Name:        Addict.h
// Purpose:     A[d]dict dictionary program
// Author:      Wayne VlK
// Copyright:   2003 (c) Wayne VlK
// Licence:     GPL 2
/////////////////////////////////////////////////////////////////////////////

// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include "wx/grid.h"
#include "wx/generic/gridctrl.h"
#include "wx/image.h"	//for MSW

#include "Addict.h"

// ----------------------------------------------------------------------------
// global initialization bits...
// ----------------------------------------------------------------------------

// the application icon (under Windows and OS/2 it is in resources)
#if defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXMAC__) || defined(__WXMGL__) || defined(__WXX11__)
    #include "addict.xpm"
#endif

BEGIN_EVENT_TABLE(AddictPanel, wxPanel)
    EVT_SIZE(AddictPanel::OnSize)
    EVT_LEFT_DOWN(AddictPanel::OnClick)
    EVT_BUTTON(-1,AddictPanel::OnClick)
    EVT_GRID_COL_SIZE(AddictPanel::OnGridResize)
    EVT_TIMER(-1,AddictPanel::OnTimer)
END_EVENT_TABLE()

#include "util/ihmem.c"	//definitions of index-hash-memory area
#include "util/ihash.c"	//definitions of index-hash (language dep.) calculation

// ----------------------------------------------------------------------------
// the application class
// ----------------------------------------------------------------------------
IMPLEMENT_APP(AddictApp)

#ifdef wxMSW
	#define MSW 1
#else
	#define MSW 0
#endif

bool AddictApp::OnInit() {
	wxSetWorkingDirectory(wxPathOnly(argv[0]));
	wxFrame *frame = new wxFrame(NULL,-1,_T(ADDICT_VER), wxPoint(0, 0), wxSize(300, 300));
	frame->SetIcon(wxICON(addict));
	wxInitAllImageHandlers();
	AddictPanel *panel = new AddictPanel(frame,-1);
	panel->Initialize(MSW);
	if(frame) frame->Show(TRUE);
	return (frame && panel);
	}
// ----------------------------------------------------------------------------
// MyStatusBar
// ----------------------------------------------------------------------------
class AddictBitmap : public wxStaticBitmap {
public:
    AddictBitmap(wxWindow *parent, wxWindowID id, wxBitmap &top, 
    		wxPoint pos, wxSize size, wxBitmap &on, wxBitmap &off);
    void SetHi(bool setit);
private:
    wxBitmap CreateBitmapForButton(bool on = FALSE);
    void OnClick (wxMouseEvent &event);
    bool ishi;
    wxBitmap *b_top, *b_on, *b_off;

    DECLARE_EVENT_TABLE()
};

BEGIN_EVENT_TABLE(AddictBitmap, wxStaticBitmap)
    EVT_LEFT_DOWN(AddictBitmap::OnClick)
    EVT_BUTTON(-1,AddictBitmap::OnClick)
END_EVENT_TABLE()

void AddictBitmap::OnClick (wxMouseEvent &event) {
	((AddictPanel*)GetParent())->OnButton(GetId());
	};

AddictBitmap::AddictBitmap (wxWindow *parent, wxWindowID id, wxBitmap &top, wxPoint pos, 
	    wxSize size, wxBitmap &on, wxBitmap &off):
	wxStaticBitmap(parent, id, top, pos, size) {

	ishi=false;
	b_top=&top;
	b_on =&on;
	b_off=&off;
	SetBitmap( CreateBitmapForButton (false) );
	};

void AddictBitmap::SetHi (bool setit) {
	if(ishi==setit) return;
	SetBitmap( CreateBitmapForButton (setit) );
	ishi=setit;
	};

wxBitmap AddictBitmap::CreateBitmapForButton (bool on) {
    int xSize = 30;
    int ySize = 30;

    if(b_on && b_on->Ok()) {
	xSize = b_on->GetWidth();
	ySize = b_on->GetHeight();
	};
    wxBitmap bitmap (xSize, ySize);
    wxMemoryDC dc;
    dc.SelectObject(bitmap);
    dc.SetBackground(wxBrush(GetParent()->GetBackgroundColour(),wxSOLID));
    dc.Clear();
    //dc.SetBrush(on ? *wxGREEN_BRUSH : *wxRED_BRUSH);
    //dc.DrawEllipse(0, 0, xSize-1, ySize-1);
	//button shade
	wxMemoryDC tmpdc;
	if(on) tmpdc.SelectObject(*b_on);
	  else tmpdc.SelectObject(*b_off);
	//dc.Blit(0,0,xSize,ySize,&tmpdc,0,0,wxAND,TRUE);
	dc.Blit(0,0,xSize,ySize,&tmpdc,0,0,wxCOPY,TRUE);
	tmpdc.SelectObject(wxNullBitmap);
	//top mask
	tmpdc.SelectObject(*b_top);
	dc.Blit(0,0,xSize,ySize,&tmpdc,0,0,wxCOPY,TRUE);
	tmpdc.SelectObject(wxNullBitmap);
    dc.SelectObject(wxNullBitmap);
    return bitmap;
    }

// ----------------------------------------------------------------------------
// an example of custom attr provider: this one makes all odd rows appear grey
// ----------------------------------------------------------------------------

class MyGridCellAttrProvider : public wxGridCellAttrProvider {
public:
    MyGridCellAttrProvider();
    void	SetOddFg(wxColour c);
    void	SetOddBg(wxColour c);
    virtual ~MyGridCellAttrProvider();
    virtual wxGridCellAttr *GetAttr(int row, int col, wxGridCellAttr::wxAttrKind  kind) const;
private:
	wxColour fg,bg;
	bool	 inifg,inibg;
    wxGridCellAttr *m_attrForOddRows;
    wxGridCellAttr *m_attrForEvenRows;
    wxGridCellAutoWrapStringRenderer *m_wrapRend;
    };

void MyGridCellAttrProvider::SetOddBg(wxColour c) {
	bg=c;
	inibg=true;
	m_attrForOddRows->SetBackgroundColour(bg);
	};

void MyGridCellAttrProvider::SetOddFg(wxColour c) {
	fg=c;
	inifg=true;
	m_attrForOddRows->SetTextColour(fg);
	};

MyGridCellAttrProvider::MyGridCellAttrProvider() {
	m_wrapRend = new wxGridCellAutoWrapStringRenderer;
	m_attrForOddRows = new wxGridCellAttr;
	m_attrForOddRows->SetBackgroundColour(*wxLIGHT_GREY);
	m_attrForOddRows->SetRenderer(m_wrapRend);
	
	m_attrForEvenRows = new wxGridCellAttr;
	m_attrForEvenRows->SetRenderer(m_wrapRend);
	inifg=false;
	inibg=false;
	}

MyGridCellAttrProvider::~MyGridCellAttrProvider() {
    m_attrForOddRows->DecRef();
    m_attrForEvenRows->DecRef();
}

wxGridCellAttr *MyGridCellAttrProvider::GetAttr(int row, int col,
                           wxGridCellAttr::wxAttrKind  kind /* = wxGridCellAttr::Any */) const {
    wxGridCellAttr *attr = wxGridCellAttrProvider::GetAttr(row, col, kind);

	if(row % 2 == 0) {
        	if ( !attr ) {
	        	attr = m_attrForEvenRows;
        		attr->IncRef();
			};
		};
    if ( row % 2 ) {
        if ( !attr ) {
        	attr = m_attrForOddRows;
        	attr->IncRef();
        	}
        else {
            if ( !attr->HasBackgroundColour() ) {
                wxGridCellAttr *attrNew = attr->Clone();
                attr->DecRef();
                attr = attrNew;
                attr->SetBackgroundColour(*wxLIGHT_GREY);
            	}
            }
    	}

    return attr;
}

#define ES(a) wxError(wxString::Format("ES: %s\n",a));

// ----------------------------------------------------------------------------
// BigGridTable class
// ----------------------------------------------------------------------------
BigGridTable::BigGridTable() {
    	no_of_lines = 0;
	ihmem_init(&mem_hash);
	ihash_init(&lang_hsh);
	};
	
long BigGridTable::NoOfLines() { 
	return no_of_lines; 
	};
	
int  BigGridTable::GetNumberRows() { 
	return no_of_lines; 
	}
	
int  BigGridTable::GetNumberCols() { 
	return 2; 
	}

void BigGridTable::Recode(wxString *which, bool backward) {
	if(!recoding.active) return;
	int i;
	//wxError(wxString::Format("%d",recoding.length));
	if(!backward)	for(i=0;i<recoding.length;i++) which->Replace(recoding.first+2*i,recoding.second+2*i);
	else		for(i=0;i<recoding.length;i++) which->Replace(recoding.second+2*i,recoding.first+2*i);
	};

wxString BigGridTable::GetValue( int row, int col ) {
	//Otestujeme, jestli mame v cache
	int which=-1;
	//fprintf(stderr,"\n\n%d:",row);
	//for(int i=0;i<CACHE_SIZE;i++)
	//int i;
	for(int i=CACHE_SIZE-1;i>=0;i--)
	    if(cline[i]==row) {
		which=i;
		break;
		};
	//wxLogError(wxString::Format("~%d~",i));
	//Nemame, tj. nahrajeme to do cache
	if(which<0) {
		//wxLogError(wxString::Format("Nenasli [%d]",row));
		long hrube=ihmem_find_line(&mem_hash,row);
		FILE *fin;
		char radek[10000];
		radek[0]=0;
		if((fin=fopen((fname.c_str()),"r"))!=NULL) {
			///*
			fseek(fin,ihmem_getfpos(&mem_hash,hrube),SEEK_SET);
			ulong cislo=ihmem_getline(&mem_hash,hrube);
			while(cislo<=((ulong)row)) {
				fgets(radek,10000,fin);
				cislo++;
				};
			fclose(fin);
			//Posledni radek->cache
			for(int i=0;i<CACHE_SIZE-1;i++) {
				cache[i]=cache[i+1];
				cline[i]=cline[i+1];
				};
			cline[CACHE_SIZE-1]=cislo-1;
			cache[CACHE_SIZE-1]=radek;
			(cache[CACHE_SIZE-1]).Trim();
			Recode(&(cache[CACHE_SIZE-1]));
			//*/
			/*
			// Teoreticky rychlejsi (mene diskovych operaci), v praxi je ale indexace natolik ucinna,
			// ze to spis zdrzuje...
			
			fseek(fin,ihmem_getfpos(&mem_hash,hrube),SEEK_SET);
			ulong cislo=ihmem_getline(&mem_hash,hrube);
			//fprintf(stderr,"Found index: %lu -> Line: %lu (Searched for line %d)\n",hrube,cislo,row);
			while(cislo<=((ulong)row)) {
				fgets(radek,1000,fin);
				//Tenhle radek mame v cache? Jinak se bude jiste hodit za chvili...
				which=-1;
				for(int i=CACHE_SIZE-1;i>=0;i--) 
					if(cline[i]==cislo) {
						which=i;
						i=-1;
						};
				//Posledni radek->cache
				if(which<0) {
					for(int i=0;i<CACHE_SIZE-1;i++) {
						cache[i]=cache[i+1];
						cline[i]=cline[i+1];
						};
					cline[CACHE_SIZE-1]=cislo;
					cache[CACHE_SIZE-1]=radek;
					(cache[CACHE_SIZE-1]).Trim();
					Recode(&(cache[CACHE_SIZE-1]));
					//wxLogError(wxString::Format("~Ukladam [%d]",cislo));
					};
				cislo++;
				};
			fclose(fin);
			*/
			};
		which=CACHE_SIZE-1;
		};
	//Vratime retezec
	if(col) return (cache[which].AfterFirst('\t')).BeforeFirst('\t');
	   else return  cache[which].BeforeFirst('\t');
	//nefunguje...
	//if( GetView() ) GetView()->AutoSizeRow(row,TRUE);
	}

void BigGridTable::SetValue( int , int , const wxString&  ) { /* ignore */ }

bool BigGridTable::IsEmptyCell( int , int  ) { 
	return FALSE;
	};
    
long BigGridTable::FindString(wxString string) {
	int  myhash[HASH_SIZE];
	int  finhsh[HASH_SIZE];
	wxString tmp_str=string;//+"                             ";
	Recode(&tmp_str,true);
	ihash_gethash(&lang_hsh, (int*)myhash, tmp_str.c_str(), 0);
	ulong myindex=ihmem_find_hash( &mem_hash, ihash_hash2ulong (myhash) );
	ulong myfpos =ihmem_getfpos  ( &mem_hash, myindex );
    	ulong myline =ihmem_getline  ( &mem_hash, myindex );
	//Search finer
	FILE *fin;
	char radek[1000];
	radek[0]=0;
	if((fin=fopen((fname.c_str()),"r"))!=NULL) {
		fseek( fin, myfpos, SEEK_SET);
		fgets(radek,1000,fin);
		ihash_gethash(&lang_hsh, (int*)finhsh, radek, 0);
		myline++;
		//while(myline<no_of_lines && hashcmp((int*)myhash,(int*)finhsh)>-1) {
		while(myline<no_of_lines && hashcmp((int*)myhash,(int*)finhsh)>0) {
			fgets(radek,1000,fin);
			ihash_gethash(&lang_hsh, (int*)finhsh, radek, 0);
			myline++;
			};
		fclose(fin);
		myline--;
		};
	return myline;
    	};
	
bool BigGridTable::SwitchFile(Addiction add) {
    	wxString par_fname=add.data;
	wxString par_lname=add.lang;
	//default_height	=add.height;
	auto_resize	=add.automatic;
    	//Load index & language
	FILE *findex;
	if((findex=fopen((par_fname+".ind").c_str(),"rb"))==NULL) return FALSE;
	ihmem_load(&mem_hash,findex);
	fclose(findex);
	if((findex=fopen((par_lname).c_str(),"r"))==NULL) return FALSE;
	ihash_load(&lang_hsh,findex);
	fclose(findex);
	//Save filename
	fname=par_fname+".txt";
	//Count size
	FILE *fin;
	char radek[1000];
	radek[0]=0;
	ulong cislo=ihmem_getline(&mem_hash,mem_hash.last);
	if((fin=fopen((fname.c_str()),"r"))!=NULL) {
		fseek(fin,ihmem_getfpos(&mem_hash,mem_hash.last),SEEK_SET);
		while(!feof(fin)) {
			fgets(radek,1000,fin);
			cislo++;
			};
		fclose(fin);
		cislo--;
		};
	long diff_ln=cislo-no_of_lines;
	no_of_lines=cislo;
	//Prepare cache
	for(int i=0;i<CACHE_SIZE;i++) cline[i]=-1;
	//Call View to say I've resized
	if( GetView() ) {
		GetView()->SetDefaultRowSize(add.height,TRUE);

		wxGridTableMessage *msg;
		if(diff_ln>0) msg= new wxGridTableMessage( this, wxGRIDTABLE_NOTIFY_ROWS_APPENDED, diff_ln);
		else msg=new wxGridTableMessage( this, wxGRIDTABLE_NOTIFY_ROWS_DELETED, cislo+diff_ln, -diff_ln);
		GetView()->ProcessTableMessage( *msg );
		delete msg;
		};
	return TRUE;
    	};
	
// ----------------------------------------------------------------------------
// text control that searches on change - only for EVT_TEXT to process
// ----------------------------------------------------------------------------
class AddictTextCtrl: public wxTextCtrl {
public:
	AddictTextCtrl(wxWindow *parent, wxPoint pos) 
		: wxTextCtrl(parent,-1,"",pos,wxDefaultSize,wxTE_PROCESS_ENTER) { 
		content.Empty();
		};
	~AddictTextCtrl() { };
	void OnKey(wxKeyEvent &event) {
		//fprintf(stderr,"Znak: %d(%c)",(char)(event.GetValue()),event.GetValue());
		//fprintf(stderr,"OnKey %d,%d\n",event.GetKeyCode(),event.GetRawKeyCode());
		//OnChange();
		if(event.GetKeyCode()==WXK_UP)		((AddictPanel*)GetParent())->OnMove( -1);
		else if(event.GetKeyCode()==WXK_DOWN) 	((AddictPanel*)GetParent())->OnMove(  1);
		else if(event.GetKeyCode()==WXK_PRIOR) 	((AddictPanel*)GetParent())->OnMove(-10);
		else if(event.GetKeyCode()==WXK_NEXT) 	((AddictPanel*)GetParent())->OnMove( 10);
		else if(event.GetKeyCode()==WXK_LEFT   && event.AltDown())
			((AddictPanel*)GetParent())->OnButton(ID_LANG+((AddictPanel*)GetParent())->addict_active-1);
		else if(event.GetKeyCode()==WXK_RIGHT  && event.AltDown())// OnButton(ID_LANG+addict_active+1);
			((AddictPanel*)GetParent())->OnButton(ID_LANG+((AddictPanel*)GetParent())->addict_active+1);
		else if(event.GetKeyCode()==WXK_DELETE && GetInsertionPoint()==GetLastPosition()) {
			Clear();
			OnChange(1);
			}
		else {
			OnChange();
			//Skip only usual characters...
			event.Skip();
			};
		};
		
	void OnTextChange(wxCommandEvent &event) {
		event.Skip();
		OnChange();
		};
	void OnTextEnter(wxCommandEvent &event) {
		event.Skip();
		OnChange(1);
		};
private:
	wxString content;
	void OnChange(bool force=FALSE) {
		if(!force && content==GetValue()) return;
		content=GetValue();
		//wxLogError(wxString::Format("Look for '%s'",content.c_str()));
		((AddictPanel*)GetParent())->OnTextChange(force);
		};
	DECLARE_EVENT_TABLE()
	};

BEGIN_EVENT_TABLE(AddictTextCtrl, wxTextCtrl)
    EVT_CHAR(AddictTextCtrl::OnKey)
    //EVT_KEY_UP(AddictTextCtrl::OnKey)
    EVT_TEXT(-1,AddictTextCtrl::OnTextChange)
    EVT_TEXT_ENTER(-1,AddictTextCtrl::OnTextEnter)
END_EVENT_TABLE()

// ----------------------------------------------------------------------------
// main panel
// ----------------------------------------------------------------------------

// panel constructor
AddictPanel::AddictPanel(wxWindow *parent,int id) : wxPanel(parent,id) {
	onthefly=false;
	staticText=new wxStaticText(this,-1, _T("Search:"), wxPoint(5,5));
	labelText =new wxStaticText(this,-1, "A[d]dict", wxPoint(5,5));
	textCtrl  =new AddictTextCtrl(this, wxPoint(80,0));
	grid      =new wxGrid(this,-1, wxPoint(5,30), wxSize(190,200));
	//grid      =new wxGrid(this,-1, wxPoint(5,30), wxSize(190,200), wxSIMPLE_BORDER);
		addtable = new BigGridTable;
		// VZ: I don't understand why this slows down the display that much
		addtable->SetAttrProvider(new MyGridCellAttrProvider);
		grid->SetTable(addtable, FALSE);
	grid->SetLabelSize(wxVERTICAL  , 0);
        grid->SetLabelSize(wxHORIZONTAL, 0);
        //grid->SetCellBackgroundColour(wxColour("WHEAT"));
        grid->SetCellHighlightPenWidth(0);
	grid->SetCellHighlightROPenWidth(0);
	grid->EnableEditing(FALSE);
	grid->EnableScrolling(FALSE,FALSE);
	//grid->SetAutoLayout( TRUE );
	//This one is terribly slow...
	//grid->AutoSizeRows( TRUE );
	grid->Refresh();
	//wxBitmap *bmp_lang[MAX_DICTS];
	wxBitmap *bmp_logo,
		 *bmp_on,
		 *bmp_off;
	bmp_logo   =new wxBitmap("./pict/logo.png"    ,wxBITMAP_TYPE_PNG);
	bmp_on     =new wxBitmap("./pict/butt-on.png" ,wxBITMAP_TYPE_PNG);
	bmp_off    =new wxBitmap("./pict/butt-off.png",wxBITMAP_TYPE_PNG);
	logo=NULL;
	if(bmp_logo && bmp_logo->Ok()) logo=new AddictBitmap(this,ID_LOGO,*bmp_logo,wxPoint(10,10),wxDefaultSize,*bmp_on,*bmp_off);
	logo->SetHi(true);
	textCtrl->SetFocus();
	lastradek=0;
	addtable->recoding.active=false;
	addtable->recoding.length=0;
	OnButTimer.SetOwner(this);
	};

void AddictPanel::OnTimer(wxTimerEvent &event) {
	if(initb) {
		//After start resize frame
		((wxFrame*)GetParent())->SetSize(initw,inith);
		initb=0;
		};
	OnTextChange(true);
	};

void AddictPanel::Initialize(bool isMSW=false) {
	FILE *fin;
	//if(!isMSW && (fin=fopen("Addict.ini","r" ))==NULL) return;
	//if( isMSW && (fin=fopen("Addict.ini","rb"))==NULL) return;
	if(isMSW) {
		if((fin=fopen("Addict.ini","rb" ))==NULL) return;
		}
	else	if((fin=fopen("Addict.ini","r"))==NULL) return;
	char radek[200];
	int  mod=0;
	addictions=0;
	wxString recode_filename;
	recode_filename.Empty();
	//Prepare bitmaps
	wxBitmap *bmp_lang,
		 *bmp_on,
		 *bmp_off;
	bmp_on     =new wxBitmap("./pict/butt-on.png" ,wxBITMAP_TYPE_PNG);
	bmp_off    =new wxBitmap("./pict/butt-off.png",wxBITMAP_TYPE_PNG);

	//read config file
	fgets(radek,200,fin);
	while(!feof(fin)) {
	    //ES(radek);
	    if(strlen(radek)>1 && radek[0]!='#') {
		if(radek[0]=='[') mod=0;
		if(strncmp("[Dictionaries]",radek,strlen("[Dictionaries]"))==0) mod=1;
		if(strncmp("[Recode]",radek,strlen("[Recode]"))==0) mod=2;
		if(strncmp("[Settings]",radek,strlen("[Settings]"))==0) mod=3;
		if(mod==3 && radek[0]!='[') {
			//Decode [Settings]
			wxString str=radek;
			str.Trim(wxBOTH);
			wxString label= str.BeforeFirst('=');
			wxString data = str.AfterFirst('=');
			if(!(label.Trim(wxBOTH).CmpNoCase("GEOMETRY"))) { 
				long xs,ys,w,h,fc;
				data.ToLong(&xs);
				data=data.AfterFirst(',');
				data.ToLong(&ys);
				data=data.AfterFirst(',');
				data.ToLong(&w);
				data=data.AfterFirst(',');
				data.ToLong(&h);
				data=data.AfterFirst(',');
				data.ToLong(&fc);
				int dx,dy;
				wxDisplaySize(&dx,&dy);
				if(xs<0 || xs>dx-200) xs=0;
				if(ys<0 || ys>dy-100) ys=0;
				if(w<200 || w>dx-xs) w=300;
				if(h<100 || h>dy-ys) h=200;
				if(fc<100 || fc>w-150) fc=150;
				//wxLogError(wxString::Format("%ld~%ld~%ld~%ld~%ld",xs,ys,w,h,fc));
				wxFrame *tatka=((wxFrame*)GetParent());
				grid->SetColSize(0,fc);
				//This ones breaks positioning of subwindows
				//tatka->SetSize(w,h);
				//tatka->SetSize(xs,ys,w,h);
				tatka->Move(xs,ys);
				//Set values to classes ones - for repositioning after 100ms
				initb=1;
				initw=w;
				inith=h;
				};
			if(!(label.Trim(wxBOTH).CmpNoCase("DRAWGRID"))) { 
				long x;
				data.ToLong(&x);
				grid->EnableGridLines(x);
				};
			if(!(label.Trim(wxBOTH).CmpNoCase("ONTHEFLY"))) { 
				long x;
				data.ToLong(&x);
				onthefly=x;
				};
			if(!(label.Trim(wxBOTH).CmpNoCase("COLORGRID"))
			|| !(label.Trim(wxBOTH).CmpNoCase("COLOREVBG"))
			|| !(label.Trim(wxBOTH).CmpNoCase("COLOREVFG"))
			|| !(label.Trim(wxBOTH).CmpNoCase("COLORODBG"))
			|| !(label.Trim(wxBOTH).CmpNoCase("COLORODFG"))) {
				wxColour ogc;
				long r,g,b;
				data.ToLong(&r);
				data=data.AfterFirst(',');
				data.ToLong(&g);
				data=data.AfterFirst(',');
				data.ToLong(&b);
				data.MakeUpper();
				label.MakeUpper();
				if((label.Find('B'))!=-1) ogc=GetBackgroundColour();
						     else ogc=GetForegroundColour();
				//wxLogError(wxString::Format("\togc:%d~%d~%d",ogc.Red(),ogc.Green(),ogc.Blue()));
				if((data.Find('R'))!=-1) {
					//Relativni
					r+=ogc.Red();
					g+=ogc.Green();
					b+=ogc.Blue();
					};
				//Borders check
				if(r>255) r=255; if(r<0) r=0;
				if(g>255) g=255; if(g<0) g=0;
				if(b>255) b=255; if(b<0) b=0;
				//Set colors
				//wxLogError(wxString::Format("%s:%ld~%ld~%ld",label.c_str(),r,g,b));
				if(!(label.Trim(wxBOTH).CmpNoCase("COLORGRID"))) grid->SetGridLineColour(wxColour(r,g,b));
				if(!(label.Trim(wxBOTH).CmpNoCase("COLOREVBG"))) grid->SetCellBackgroundColour(wxColour(r,g,b));
				if(!(label.Trim(wxBOTH).CmpNoCase("COLOREVFG"))) grid->SetCellTextColour(wxColour(r,g,b));
				MyGridCellAttrProvider *cap=(MyGridCellAttrProvider*)((grid->GetTable())->GetAttrProvider());
				if(!(label.Trim(wxBOTH).CmpNoCase("COLORODBG"))) cap->SetOddBg(wxColour(r,g,b));
				if(!(label.Trim(wxBOTH).CmpNoCase("COLORODFG"))) cap->SetOddFg(wxColour(r,g,b));
				};
			};
		if(mod==2 && radek[0]!='[') {
			//Decode [Recode]
			wxString str=radek;
			str.Trim(wxBOTH);
			wxString platform= str.BeforeFirst('=');
			wxString name = str.AfterFirst('=');
			if(isMSW && (platform.CmpNoCase("WIN") || platform.CmpNoCase("WINDOWS"))) 
				recode_filename=name+".rec";
			if(!isMSW && (platform.CmpNoCase("UNX") || platform.CmpNoCase("UNIX"))) 
				recode_filename=name+".rec";
			};
		//ES(recode_filename);
		if(mod==1 && radek[0]!='[') {
			//Decode [Dictionaries]
			wxString str=radek;
			str.Trim(wxBOTH);
			wxString title= str.BeforeFirst('=');
			wxString name = str.AfterFirst('=');
			wxString lang =name.AfterFirst(',');
			//ES(title);
			str =lang.AfterFirst (',');
			ulong	height=20,
				automatic=0;
			if(!(str.BeforeFirst(',').ToULong(&height))) height=20;
			str.AfterFirst(',').ToULong(&automatic);
			name=name.BeforeFirst(',');
			lang=lang.BeforeFirst(',');
			//Put it into addiction:
			name="./data/"+name;
			lang="./lang/lang."+lang;
			strcpy(addiction[addictions].name,title.c_str());
			strcpy(addiction[addictions].lang, lang.c_str());
			strcpy(addiction[addictions].data, name.c_str());
			addiction[addictions].height=height;
			addiction[addictions].automatic=(automatic!=0);
			bmp_lang=new wxBitmap(name+".png",wxBITMAP_TYPE_PNG);
			btn_lang[addictions]=new AddictBitmap(this,ID_LANG+addictions,*bmp_lang,wxPoint(10,10),wxDefaultSize,*bmp_on,*bmp_off);
			addictions++;
			};
		};
	    fgets(radek,200,fin);
	    };
	fclose(fin);
	//Load first dictionary
	//ES(addiction[0].data);
	//ES(addiction[0].lang);
	addict_active=-1;
	OnButton(ID_LANG);
	/*
	if(!(addtable->SwitchFile(addiction[0])))
		wxMessageBox("Error occured during first language load","Addict error",wxOK|wxICON_EXCLAMATION);
	labelText->SetLabel(addiction[0].name);
	addict_active=0;
	*/
	for(int i=0; i<addictions; i++) btn_lang[i]->SetHi(!i);
	//Load recoding table if needed
	if(recode_filename.Length()>1) {
		recode_filename.Prepend("./lang/");
		//ES(recode_filename);
		if((fin=fopen(recode_filename,"r"))!=NULL) {
			char first[257];
			char second[257];
			fgets(first,256,fin);
			fgets(second,256,fin);
			for(unsigned int i=0;i<wxMax(strlen(first),strlen(second))-1;i++) {
				addtable->recoding.first [2*i  ]=first[i];
				addtable->recoding.first [2*i+1]=0;
				addtable->recoding.second[2*i  ]=second[i];
				addtable->recoding.second[2*i+1]=0;
				//addtable->recoding.first [i]=first[i];
				//addtable->recoding.second[i]=second[i];
				};
			addtable->recoding.length=wxMin(strlen(first),strlen(second))-1;
			addtable->recoding.active=true;
			fclose(fin);
			};
		};
	};

void AddictPanel::OnButton(int id) {
	if(id==100) 
		wxMessageBox(ADDICT_VER"\nA (d)dictonary program for various dictionaries\n\n2003(c)Wayne VlK\nLicence: GPL2 (see www.gnu.org)\n\nAddict is sponsored by www.abclinuxu.cz","About Addict...",wxOK|wxICON_INFORMATION);
	if(id>=ID_LANG && id<ID_LANG+addictions && (id-ID_LANG)!=addict_active) {
		if(!(addtable->SwitchFile(addiction[id-ID_LANG])))
			wxMessageBox("Error occured during language switch","Addict error",wxOK|wxICON_EXCLAMATION);
		labelText->SetLabel(addiction[id-ID_LANG].name);
		addict_active=id-ID_LANG;

		for(int i=0; i<addictions; i++) btn_lang[i]->SetHi(i==id-ID_LANG);
		OnTextChange(true);
		grid->ForceRefresh();
		textCtrl->SetFocus();
		OnButTimer.Start(100,true); //After 100ms search for content of text field
		};
	};

void AddictPanel::OnClick (wxMouseEvent &event) {
	//not used now...
	int ex,ey;
	event.GetPosition(&ex,&ey);
	if(event.GetId()==100) wxMessageBox("Addict v.0.1\nA (d)dictonary program for various dictionaries\n\n2003(c)Wayne VlK\nLicence: GPL2 (see www.gnu.org)","About Addict...",wxOK|wxICON_INFORMATION);
	};

#define PRE_RESIZE 10
#define POSTRESIZE 50

void AddictPanel::OnMove (int diff) {
	if(diff==0) return;
	if(lastradek+diff<0 || lastradek+diff>=addtable->NoOfLines()) return;
	grid->MakeCellVisible(lastradek+diff,0,TRUE);
	if(diff>0) 
		for(int i=wxMin(addtable->NoOfLines(),lastradek+POSTRESIZE);
			i<wxMin(addtable->NoOfLines(),lastradek+POSTRESIZE+diff);
			i++) grid->AutoSizeRow(i,TRUE);
	if(diff<0) 
		for(int i=wxMax(0,lastradek-PRE_RESIZE+diff);
			i<wxMax(0,lastradek-PRE_RESIZE);
			i++) grid->AutoSizeRow(i,TRUE);
	lastradek+=diff;
	grid->ForceRefresh();
	}

void AddictPanel::OnTextChange (bool isEnter) {
	if(!onthefly && !isEnter) return;
	//if(!isEnter) return;
	long radek=addtable->FindString(textCtrl->GetValue());
	//wxLogError(wxString::Format("radek: %ld\n",radek));
	if(addtable->auto_resize)
		for(int i=wxMin(addtable->NoOfLines(),wxMax(0,radek-PRE_RESIZE));
			i<wxMin(addtable->NoOfLines(),wxMax(0,radek+POSTRESIZE));
			i++) grid->AutoSizeRow(i,TRUE);
			//grid->AutoSizeRow(wxMin(addtable->NoOfLines(),wxMax(0,radek+i)),TRUE);
		lastradek=radek;
	grid->ForceRefresh();
	grid->MakeCellVisible(radek,0,TRUE);
	grid->ForceRefresh();
	}

void AddictPanel::OnGridResize ( wxGridSizeEvent &event ) {
	if(grid) {
		int	wc=(GetClientSize().x)-10; 
		int	we=(event.GetPosition()).x;
		if(we>10 && we<wc-30) {
			//1. sloupec rozsirime
			grid->SetColSize(0,we);
			grid->SetColSize(1,wc-(grid->GetColSize(0))-20);
			grid->ForceRefresh();
			};
		};
	event.Skip();
	}

void AddictPanel::OnSize(wxSizeEvent& WXUNUSED(event)) {
	wxSize size = GetClientSize();
	int 	stx=5,
		enx=size.x-5,
		sty=30,
		eny=size.y-35;
	//Horni radek
	if(logo) {
		int w=0,h=0;
		logo->GetSize(&w,&h);
		logo->SetSize(size.x-w,0,w,h);
		enx=size.x-5-w;
		//sty=wxMax(20,h);
		sty=h;
		};
	if(staticText) {
		int w=0,h=0;
		staticText->GetSize(&w,&h);
		staticText->SetSize(5,(sty-h)/2,w,h);
		stx=10+w;
		};
	if(textCtrl) {
		int w=0,h=0;
		textCtrl->GetSize(&w,&h);
		//h=wxMin(30,h);
		textCtrl->SetSize(stx, (sty-h)/2, enx-stx, h);
		};
	//Spodni radek
	if(labelText) {
		int w=0,h=0;
		labelText->GetSize(&w,&h);
		labelText->SetSize(5,eny+5+(30-h)/2,w,h);
		};
	int i=0;
	while(i<addictions && btn_lang[i]) {
		int w=0,h=0;
		btn_lang[i]->GetSize(&w,&h);
		btn_lang[i]->SetSize(size.x-(addictions-i)*30+(30-w)/2,eny+5,w,h);
		i++;
		};
	sty+=5;
	//Tabulka
	if(grid) {
		int	w1,wc;
		wc=size.x-10; 
		//grid->SetSize(5,35,wc,size.y-35-h-10);
		grid->SetSize(5,sty,wc,eny-sty);
		//2. sloupec rozsirime
		w1=grid->GetColSize(0);
		grid->SetColSize(1,wc-w1-20);//20 pro scrollbar
		grid->ForceRefresh();
		};
	//wxLogError(wxString::Format("%d x %d vs. %d x %d",size.x,size.y,w,h));
	}

AddictPanel::~AddictPanel() {
	};

// Konec <Addict.cpp>
