/////////////////////////////////////////////////////////////////////////////
// Name:        Addict.h
// Purpose:     A[d]dict dictionary program
// Author:      Wayne VlK
// Copyright:   2003 (c) Wayne VlK
// Licence:     GPL 2
/////////////////////////////////////////////////////////////////////////////

#ifndef addict_h
#define addict_h

#define MAX_DICTS 10
#define ADDICT_VER "A[d]dict - v.0.31"

#if !defined(wxUSE_NEW_GRID) || !(wxUSE_NEW_GRID)
    #error "This program requires the new wxGrid class."
#endif

#include "wx/grid.h"
#include "./util/ihash.h"
#include "./util/ihmem.h"

enum {
	ID_ABOUT = 100,
	ID_QUIT
	};

typedef struct{
	char lang[200];
	char data[200];
	char name[20];
	int  height;
	bool automatic;
	} Addiction;

typedef struct{
	bool active;
	char first[513];	//2*256 is theoretical max.
	char second[513];
	int  length;
	} Recoding;

//class wxGrid;

class AddictApp : public wxApp {
public:
	bool OnInit();
	};

// ----------------------------------------------------------------------------
// BigGridTable class
// ----------------------------------------------------------------------------
#define CACHE_SIZE 100
class BigGridTable : public wxGridTableBase {
public:
	BigGridTable();
	long NoOfLines();
	int  GetNumberRows();
	int  GetNumberCols();
	void Recode(wxString *which, bool backward=false);
	wxString GetValue( int row, int col );
	void SetValue( int , int , const wxString&  );
	bool IsEmptyCell( int , int  ); 
	long FindString(wxString string);
	bool SwitchFile(Addiction add);
	
	Recoding recoding;
	bool 	 auto_resize;
private:
	ihmem	 mem_hash;
	ihash	 lang_hsh;
	wxString fname;
	wxString cache[CACHE_SIZE];
	long	 cline[CACHE_SIZE];
	ulong	 no_of_lines;
	};
    
// ----------------------------------------------------------------------------
// AddictPanel class
// ----------------------------------------------------------------------------
class AddictBitmap;

#define ID_LOGO 100
#define ID_LANG 101

class AddictPanel : public wxPanel {
public:
    wxGrid         *grid;
    BigGridTable   *addtable;
    wxTextCtrl     *textCtrl;
    wxStaticText   *staticText;
    wxStaticText   *labelText;
    AddictBitmap   *btn_lang[MAX_DICTS];
    AddictBitmap   *logo;
    Addiction      addiction[MAX_DICTS];
    int            addictions;
    int		   addict_active;
    long	   lastradek;
    	bool		 onthefly;
	//Search in bigger database after switch
	//this may be surely implemented better!
	wxTimer		 OnButTimer;
	void		 OnTimer(wxTimerEvent &event);
	//Even worse:
	//Size of initialized window can't be set directly :-(
	int		 initb,initw,inith;

	AddictPanel	 (wxWindow *parent, int id);
	~AddictPanel	 ();
	void Initialize	 (bool isMSW);
	void OnSize	 (wxSizeEvent &event);
	void OnTextChange(bool isEnter=false);
	void OnGridResize(wxGridSizeEvent &event);
	void OnClick     (wxMouseEvent &event);
	void OnButton	 (int id);
	void OnMove	 (int diff);

	DECLARE_EVENT_TABLE()
	};

#endif // addict_h
