#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define uchar unsigned char
#define ulong unsigned long

#define IHASH_BLOCK 255
#define HASH_SIZE   20
#define DUMMY_HASH  255 //113

#include "ihash.h"
/*
typedef struct {
	char len;
	char str[10];
	char first;
	int  val;
	} langrow;

typedef struct {
	long size;
	long last;
	langrow *data;
	} ihash;
*/
#define LRS sizeof(langrow)

void ihash_init(ihash *mem) {
	mem->size=0;
	mem->last=0;
	mem->data=NULL;
	};

void ihash_insert(ihash *mem, langrow lr) {
	if(!(mem->data)) {
		mem->data=(langrow*)malloc(IHASH_BLOCK*LRS);
		mem->size=IHASH_BLOCK;
		mem->last=0;
		mem->data[0]=lr;
		//fprintf(stderr,"First: %c, Len: %d, Str: %s = Val: %d\n",lr.first,lr.len,lr.str,lr.val);
		return;
		};
	if(mem->last==mem->size-1) {
		mem->data=(langrow*)realloc(mem->data,(mem->size+IHASH_BLOCK)*LRS);
		mem->size=mem->size+IHASH_BLOCK;
		};
	mem->last++;
	mem->data[mem->last]=lr;
	//fprintf(stderr,"First: %c, Len: %d, Str: %s = Val: %d\n",lr.first,lr.len,lr.str,lr.val);
	};

int get_radek_value(char *radek) {
	//Pomocna funkce pro cteni lang definicniho souboru
	unsigned int ptr=0;
	int tab=0;
	int val=-1;
	while(ptr<strlen(radek)) {
		if(radek[ptr]=='\t') {
			tab=ptr;
			val=atoi(radek+ptr+1);
			radek[ptr]=0;
			ptr=strlen(radek)+1;
			};
		ptr++;
		};
	return val;
	};

void ihash_load(ihash *tbl, FILE *flang) {
	//Nacte ze souboru razeni (serazenou tabulku)
	//Tabulka musi byt jiz inicializovana, soubor otevren pro cteni
	char  radek[100];
	int   radek_val;
	langrow temp_lr;
	temp_lr.str[9]=0;
	
	//Vycistime tabulku
	if(tbl->data) free(tbl->data);
	ihash_init(tbl);
	
	while(!feof(flang)) {
		fgets(radek,100,flang);
		radek[99]=0;
		//fgets nacita i koncovy \n:
		if(strlen(radek)>0) radek[strlen(radek)-1]=0;
		//Zjistime value a zaroven upravime radek
		radek_val=get_radek_value(radek);
		if(strlen(radek)==1) {
			//Nejcastejsi varianta, jednoznakovy radek
			temp_lr.first =radek[0];
			temp_lr.len   =0;
			temp_lr.str[0]=0;
			temp_lr.val   =radek_val;
			ihash_insert(tbl,temp_lr);
			}
		else if(strlen(radek)>1) {
			//Viceznakovy radek
			strncpy(temp_lr.str,radek,9);
			temp_lr.len  =strlen(temp_lr.str);
			temp_lr.first=radek[0];
			temp_lr.val  =radek_val;
			ihash_insert(tbl,temp_lr);
			};
		};
	};

void ihash_close(ihash *mem) {
	if(mem->data) free(mem->data);
	mem->data=NULL;
	mem->size=0;
	mem->last=0;
	};
	
ulong ihash_hash2ulong(int *t) {
	ulong now_hash=0;
	now_hash=         ((t[0])<<24);
	now_hash=now_hash+((t[1])<<16);
	now_hash=now_hash+((t[2])<< 8);
	now_hash=now_hash+t[3];
	return now_hash;
	};

int hashcmp(int *hash1, int *hash2) { 
	return memcmp(hash1,hash2,HASH_SIZE*sizeof(int));
	};

int ihash_charhash(ihash *mem, const char *ret, int *posun) {
	//Vrati hash jednoho subretezce (obvykle znak)
	//+ nastavi posun na delku tohoto subretezce
	int i;

	if(!ret || ret[0]==0 || ret[0]=='\t' || ret[0]=='\n') {
		//Neni s cim porovnavat
		(*posun)=0;
		//return DUMMY_HASH;
		return 0;
		};
	for(i=0;i<=(mem->last);i++) 
	  if(mem->data[i].first==ret[0]) {
	  	unsigned mdil=(mem->data[i]).len;
	  	if(mdil) {
			if(strlen(ret)>=mdil && !strncmp(mem->data[i].str,ret,mdil)) {
				//Zkontrolovan zbytek retezce
				(*posun)=mdil;
				return mem->data[i].val;
				};
			}
		else {
			//Jednoznakovy pripad
			(*posun)=1;
			return mem->data[i].val;
			};
	  	};
	(*posun)=0;
	return DUMMY_HASH;
	};

void ihash_gethash(ihash *mem, int *hash, const char *radek, int usefield) {
	unsigned int ptr=0;
	int i;
	
	if(!mem || !radek || !hash) return;
	while(usefield>0) {
		if(ptr<strlen(radek)) {
			if(radek[ptr]=='\t') usefield--;
			ptr++;
			}
		else return;
		};
	if(ptr>strlen(radek)) ptr=strlen(radek);
	for(i=0;i<HASH_SIZE;i++) {
		int posun;
		hash[i]=ihash_charhash(mem,radek+ptr,&posun);
		ptr+=posun;
		};
	};

//Konec souboru <ihmem.c>
