#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "ihmem.h"

#define uchar unsigned char

#define IHMEM_BLOCK 100000
#define ULS sizeof(ulong)
#define DES 3

/* in ihmem.h
typedef struct {
	ulong size;	//V nasobcich DES*sizeof(long)
	ulong last;	//dtto
	ulong *data;	//hash,fpos,line
	} ihmem;
*/	

void ihmem_init	 (ihmem *mem) {
	mem->size=0;
	mem->last=0;
	mem->data=NULL;
	};

void ihmem_insert(ihmem *mem, ulong hash, ulong fpos, ulong lpos) {
	if(!(mem->data)) {
		mem->data=(ulong*)malloc(IHMEM_BLOCK*DES*ULS);
		mem->size=IHMEM_BLOCK;
		mem->last=0;
		mem->data[0]=hash;
		mem->data[1]=fpos;
		mem->data[2]=lpos;
		return;
		};
	if(hash!=mem->data[mem->last*DES]) {
		if(mem->last==mem->size-1) {
			mem->data=(ulong*)realloc(mem->data,(mem->size+IHMEM_BLOCK)*DES*ULS);
			mem->size=mem->size+IHMEM_BLOCK;
			};
		mem->last++;
		mem->data[DES*(mem->last)]  =hash;
		mem->data[DES*(mem->last)+1]=fpos;
		mem->data[DES*(mem->last)+2]=lpos;
		};
	};

ulong ihmem_find(ihmem *mem, ulong needle, char offset) {
	ulong delta;
	ulong start=1;
	ulong *buff=(mem->data);
	
	if(!buff) return 0;
	if(offset>2 || offset<0) return 0;
	//Slovnik je serazen, muzeme tedy pulenim intervalu
	while(start<(mem->last)) start=start<<1;
	//start=start/2;
	start=start>>1;
	delta=start>>1;
	while(delta) {
		//if(delta==1) fprintf(stderr,"Search %lu: data[%lu*X+Y] = %lu (delta=%lu)\n",needle,start,buff[DES*start+2],delta);
		if(buff[DES*start+offset]>needle) {
			start=start-delta;
			}
		else if(buff[DES*start+offset]==needle){
			delta=0;
			}
		else {
			start=start+delta;
			if(start>(mem->last)) start=mem->last;
			};
		delta=delta>>1;
		};
	//Muze byt +- jeden (napr. prvni)
	if(buff[DES*start+offset]>needle) start--;
	//if(buff[DES*(start+1)+offset]<needle) start++;
	return start;
	};

ulong ihmem_find_hash(ihmem *mem, ulong needle) {
	return ihmem_find(mem,needle,0);
	};

ulong ihmem_find_fpos(ihmem *mem, ulong needle) {
	return ihmem_find(mem,needle,1);
	};

ulong ihmem_find_line(ihmem *mem, ulong needle) {
	return ihmem_find(mem,needle,2);
	};

ulong ihmem_gethash(ihmem *mem, ulong index) {
	if(!(mem->data)) return 0;
	if(index>(mem->last)) index=mem->last;
	return ((mem->data)[DES*index]);
	};

ulong ihmem_getfpos(ihmem *mem, ulong index) {
	if(!(mem->data)) return 0;
	if(index>(mem->last)) index=mem->last;
	return ((mem->data)[DES*index+1]);
	};

ulong ihmem_getline(ihmem *mem, ulong index) {
	if(!(mem->data)) return 0;
	if(index>(mem->last)) index=mem->last;
	return ((mem->data)[DES*index+2]);
	};

void ihmem_load(ihmem *mem, FILE *f) {
	//Nacte z jiz otevreneho binarniho souboru f index
	//mem bude nahrazena novym obsahem, musi vsak byt jiz alokovana
	ulong i;
	uchar *uch;
	//Nejprve delka indexu
	uch=(uchar*)(&(mem->last));
	for(i=0;i<ULS                  ;i++) uch[i]=(uchar)(fgetc(f));
	//fprintf(stderr,"Index: %ld\n",mem->last);
	//Naalokujeme mem->data
	if(mem->data) free(mem->data);
	mem->data=(ulong*)malloc((mem->last+1)*DES*ULS);
	mem->size=mem->last+1;
	//Ted samotny index
	uch=(uchar*)(mem->data);
	for(i=0;i<ULS*DES*((mem->last)+1);i++) uch[i]=(uchar)(fgetc(f));
	};
	
void ihmem_save(ihmem *mem, FILE *f) {
	ulong i;
	uchar *uch;
	//Nejprve delka indexu
	uch=(uchar*)(&(mem->last));
	for(i=0;i<ULS                  ;i++) fputc((int)(uch[i]),f);
		//int x=uch[i];
		//fputc(x,f);
		//};
	//Ted samotny index
	uch=(uchar*)(mem->data);
	for(i=0;i<ULS*DES*((mem->last)+1);i++) fputc((int)(uch[i]),f);
	};

void ihmem_close(ihmem *mem) {
	if(mem->data) free(mem->data);
	mem->data=NULL;
	mem->size=0;
	mem->last=0;
	};
//Konec souboru <ihmem.c>
