#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "ihash.c"

#define BAD_ARG 1
#define LANG_PREFIX "../lang/lang"

void chcipni(int id) {
	//Chcipne s exit number id
	//Obcas vypise nejaky help
	fprintf(stderr,"Dictionary indexer\n");
	fprintf(stderr,"~~~~~~~~~~~~~~~~~~\n");
	fprintf(stderr,"Usage:   indexer language dictionary_file [field_number]\n");
	fprintf(stderr,"Example: indexer cs-iso slovnik.txt 2\n");
	exit(id);
	};

int main(int argc, char **argv) {
	FILE  *fin;
	int   usefield;
	char  langname[200];
	char  radek[10000];
	int   i;
	int   hash[HASH_SIZE+1];
	ihash langtab;
	
	if(argc<3) chcipni(BAD_ARG);
	//Ktery sloupec pouzit
	if(argc==4) usefield=atoi(argv[3])-1;
	if(usefield<1) usefield=0;
	//Naalokovat langtab
	ihash_init(&langtab);
	//Nacist jazyk pro indexaci
	sprintf(langname,LANG_PREFIX".%s",argv[1]);
	if(!(fin=fopen(langname,"r"))) chcipni(BAD_ARG);
	ihash_load(&langtab,fin);
	//langtab_size=load_lang(langname,langtab,LANG_TBL_SIZE);
	fclose(fin);
	//A cteme slovnikovy file
	if(!(fin=fopen(argv[2],"r"))) chcipni(BAD_ARG);
	hash[HASH_SIZE]=0;
	while(!feof(fin)) {
		long pos;
		pos=ftell(fin);
		fgets(radek,10000,fin);
		if(strlen(radek) && radek[0]!='#') {
			//lang_hash(hash,radek,usefield,langtab,langtab_size);
			ihash_gethash(&langtab,hash,radek,usefield);
			for(i=0;i<HASH_SIZE;i++) printf("%03d",hash[i]);
			printf("\t");
			printf("%ld",pos);
			printf("\n");
			};
		};
	fclose(fin);
	return 0;
	};
