#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ihash.c"
#include "ihmem.c"

#define HASH_SIZE 20
#define uchar unsigned char
#define ulong unsigned long

void chcipni(int id) {
	//Chcipne s exit number id
	//Obcas vypise nejaky help
	fprintf(stderr,"Dictionary stripper/rebuilder\n");
	fprintf(stderr,"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
	fprintf(stderr,"Usage:   stripper index_input  index_output  [dict_input  dict_output]\n");
	fprintf(stderr,"Example: stripper slovnik.sind slovnik-cs.ind slovnik.txt slovnik-cs.txt\n");
	fprintf(stderr,"         stripper slovnik.sind slovnik.ind\n");
	exit(id);
	};

#define IRADEK_SIZE 1000
#define SRADEK_SIZE 10000

int main(int argc, char **argv) {
	FILE	*fsin,*fsout,	//slovnik.txt, slovnik-cs.txt
		*fiin,*fiout;	//slovnik.sind,slovnik-cs.ind
	char	sradek[SRADEK_SIZE];
	char	iradek[IRADEK_SIZE];
	long	now_hash;
	long	now_fpos;
	long	now_line;
	long	max_fpos;
	int	sortdict;
	ihmem	the_ihmem;
	int	i;
	
	//Nastavime params, otevreme soubory
	if(argc<3 || argc==4) chcipni(1);
	if(!(fiin =fopen(argv[1],"r"))) chcipni(2);
	if(!(fiout=fopen(argv[2],"wb"))) chcipni(2);
	if(argc>3) {
		if(!(fsin =fopen(argv[3],"r"))) chcipni(2);
		if(!(fsout=fopen(argv[4],"w"))) chcipni(2);
		fseek(fsin,0,SEEK_END);
		max_fpos=ftell(fsin);
		//fprintf(stderr,"%ld\n",max_fpos);
		sortdict =1;
		}
	else {
		sortdict =0;
		};
	now_line=-1;
	//Inicializujeme ihmem
	ihmem_init(&the_ihmem);
		
	//Cteme indexer file radek po radku
	while(!feof(fiin)) {
		fgets(iradek,IRADEK_SIZE,fiin);
		//Calc hash
		now_hash=0;
		if(strlen(iradek)>12) {
			ulong t[4];
			t[0]=100*(iradek[0]-'0')+10*(iradek[ 1]-'0')+(iradek[ 2]-'0');
			t[1]=100*(iradek[3]-'0')+10*(iradek[ 4]-'0')+(iradek[ 5]-'0');
			t[2]=100*(iradek[6]-'0')+10*(iradek[ 7]-'0')+(iradek[ 8]-'0');
			t[3]=100*(iradek[9]-'0')+10*(iradek[10]-'0')+(iradek[11]-'0');
			now_hash=ihash_hash2ulong((int*)t);
			now_line++;
			};
		//Najdeme fpos
		now_fpos=0;
		i=12;
		while(i<strlen(iradek) && iradek[i]!='\t') i++;
		if(i<strlen(iradek)) now_fpos=atol(iradek+i);
		if(sortdict && now_fpos<max_fpos) {
			int  first;
			int  second;
			char *tptr;
			fseek(fsin,now_fpos,SEEK_SET);
			fgets(sradek,SRADEK_SIZE,fsin);

			//fprintf(stderr,"%s",sradek);
			tptr   =strchr(sradek,'\t');
			if(tptr) first =strlen(sradek)-strlen(tptr);
			    else first =-1;
			if(tptr) tptr   =strchr(tptr+1,'\t');
			if(tptr) second=strlen(sradek)-strlen(tptr);
			    else second=-1;
			if(first >-1) sradek[ first]=0;
			if(second>-1) sradek[second]=0;
			now_fpos=ftell(fsout);
			if(first>-1 && second!=first+1) {
				//Kdyz neexistuje preklad, nebrat
				fprintf(fsout,"%s\t%s",sradek,sradek+first+1);
				if(second>-1) fprintf(fsout,"\t%s",sradek+second+1);
				};
			};
		//!!!
		//printf("%lu:%lu\n",now_hash,now_fpos);
		//fprintf(stderr,"%lu:%lu\n",now_hash,now_fpos);
		ihmem_insert(&the_ihmem,now_hash,now_fpos,now_line);
		};
	fclose(fiin);
	//fprintf(stderr,"ukladame...");
	ihmem_save(&the_ihmem,fiout);
	ihmem_close(&the_ihmem);
	fclose(fiout);
	if(sortdict) {
		fclose(fsin);
		fclose(fsout);
		};
	return 0;
	};
